package w83b.w83bManager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bListImpugnacionesBean;
import w83b.w83bBeans.W83bListaDelegadosBean;
import w83b.w83bBeans.W83bListadosActasVivasCentroRepeBean;
import w83b.w83bBeans.W83bListadosBean;
import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bDAO.W83bFactoriaDAO;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;


public class W83bListados implements W83bIListados {
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIListados#buscarEmpresasVariosPreavisos(w83b.w83bBeans.W83bListadosBean)
	 */
	public java.util.List buscarEmpresasVariosPreavisos(w83b.w83bBeans.W83bListadosBean param) throws Exception{
	
		List listaEmpresasVariosPreavisos = W83bFactoriaDAO.getListadosDAO().buscarEmpresasVariosPreavisos(param);
		
		return listaEmpresasVariosPreavisos;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIListados#buscarLibroRegistroPreavisos(w83b.w83bBeans.W83bListadosBean)
	 */
	public java.util.List buscarLibroRegistroPreavisos(w83b.w83bBeans.W83bListadosBean param) throws Exception{
	
		List listaLibroRegistroPreavisos = W83bFactoriaDAO.getListadosDAO().buscarLibroRegistroPreavisos(param);
		
		return listaLibroRegistroPreavisos;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIListados#buscarRelacionAlfabeticaPreavisos(w83b.w83bBeans.W83bListadosBean)
	 */
	public java.util.List buscarRelacionAlfabeticaPreavisos(w83b.w83bBeans.W83bListadosBean param) throws Exception{
	
		List listaRelacionAlfabeticaPreavisos = W83bFactoriaDAO.getListadosDAO().buscarRelacionAlfabeticaPreavisos(param);
		
		return listaRelacionAlfabeticaPreavisos;	
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bManager.W83bIListados#buscarLibroRegistroActas(w83b.w83bBeans.W83bListadosBean)
	 */
	public java.util.List buscarLibroRegistroActas(w83b.w83bBeans.W83bListadosBean param) throws Exception{
		
		List listaLibroRegistroActas = W83bFactoriaDAO.getListadosDAO().buscarLibroRegistroActas(param);
		for (int i=0;i<listaLibroRegistroActas.size();i++){
			W83bListadosBean lb = (W83bListadosBean)listaLibroRegistroActas.get(i);
			W83bListadosBean mun=W83bFactoriaDAO.getListadosDAO().obtenerMunicipio(lb);
			lb.setIdcomarca(mun.getIdcomarca());
			lb.setMunicipio(mun.getDescmunicipio());
			if (mun.getIdcomarca()!=null){
				W83bListadosBean com=W83bFactoriaDAO.getListadosDAO().obtenerComarca(lb);
				lb.setComarca(com.getDesccomarca());
			}
			else{
				lb.setComarca("");
			}
		}
		return listaLibroRegistroActas;	
	}
	
/* (non-Javadoc)
 * @see w83b.w83bManager.W83bIListados#buscarResolucionesDenegatorias(w83b.w83bBeans.W83bListadosBean)
 */
public java.util.List buscarResolucionesDenegatorias(w83b.w83bBeans.W83bListadosBean param) throws Exception{
	
		List listaActas=new ArrayList();
		
		if ("1".equals(param.getOpcionListResolden())){
			listaActas = W83bFactoriaDAO.getListadosDAO().buscarResolDenFaltapreaviso(param);
//			if(StringUtils.isNotEmpty(param.getFechaResolucion())){
//				for(int i=0;i<listaActas.size();i++){
//					W83bListadosBean listado=(W83bListadosBean)listaActas.get(i);
//					listado.setFechaResolucion(param.getFechaResolucion());
//				}
//			}
		}
		else{
			listaActas = W83bFactoriaDAO.getListadosDAO().buscarResolDenLaudoNegativo(param);
		}
		return listaActas;	
	}

public List buscarReqMesaActas(W83bListadosBean param) throws Exception {
	List listaReqMesasActas = W83bFactoriaDAO.getListadosDAO().buscarReqMesasActas(param);
	
	return listaReqMesasActas;	
}
public List buscarEmpresasVariosCentros(W83bListadosBean param) throws Exception {
	List listaReqMesasActas = W83bFactoriaDAO.getListadosDAO().buscarEmpresasVariosCentros(param);
	List listaResultados=new ArrayList();
	List actas;
	
	//this.cif
	Map mapa = new HashMap();
	actas=W83bFactoriaDAO.getListadosDAO().buscarActasPorCentros(null, param.getFechaEntradaDesde(), param.getFechaEntradaHasta(), param.getIdioma(), param.getUsuarioBean());	
	W83bClsTrazas.trazaDebug(null, "numActas :"+ actas.size());
	
	for(int i=0;i<actas.size();i++){
		W83bListadosBean elActa=(W83bListadosBean)actas.get(i);
		mapa.put(elActa.getCif(), elActa.getCodCentro());		
	}	
	

	for(int i=0;i<listaReqMesasActas.size();i++){
		W83bListadosBean listado=(W83bListadosBean)listaReqMesasActas.get(i);
	
		Integer numCentros = new Integer("0");//NOPMD
	
		if(StringUtils.isNotEmpty((String)mapa.get(listado.getCif()))){
			numCentros = new Integer((String)mapa.get(listado.getCif()));//NOPMD
		}
		
		if(numCentros.intValue()>1){
			listaResultados.add(listado);
		}
		
	}
	
	return listaResultados;	
}
public List buscarTerritorioOtraDireccion(W83bListadosBean param) throws Exception {
	List listaterritorios = W83bFactoriaDAO.getListadosDAO().buscarTerritorioOtraDireccion(param);
	
	return listaterritorios;	
}
public List buscarRelImpugnaciones(W83bListImpugnacionesBean param) throws Exception {
	List listaActas = W83bFactoriaDAO.getListadosDAO().buscarRelImpugnaciones(param);
	List listaFinal = new ArrayList();
	boolean agnadido = false;
	
	Iterator ite=listaActas.iterator();
	W83bActasBean actaBean = null;
	W83bPreavisosBean preavisoBean = null;
	while (ite.hasNext()){
		W83bListImpugnacionesBean impugBean = (W83bListImpugnacionesBean) ite.next();
		agnadido = false;
		actaBean = null;
		preavisoBean = null;
		if("1".equals(impugBean.getOrderby())){
			actaBean = new W83bActasBean();//NOPMD
			actaBean.setNumActa(impugBean.getNumActa());
			actaBean.setAnyoActaTotal(impugBean.getAgnoActa());
			actaBean.setTerritorioActaTotal(impugBean.getTerritorio());
			actaBean.setVersion(impugBean.getVersionActa());
			actaBean.setNumImpug(impugBean.getNumImpugnacion());
			actaBean.setObservaciones(impugBean.getObservaciones());
			actaBean.setFechaEntrada(impugBean.getFechaEntrada());
			actaBean.setFechaBaja(impugBean.getFechaBaja());
			actaBean.setCodCentroTrabajo(impugBean.getCodcentro());
			actaBean.setRazonSocial(impugBean.getRazonSocial());
			actaBean.setDomicilio(impugBean.getDomicilio());
			actaBean.setAgnoImpug(impugBean.getAgnoImpugnacion());
			actaBean.setFechaImpug(impugBean.getFechaImpugnacion());
			actaBean.setIdioma(param.getIdioma());
				if(actaBean.getFechaBaja()==null&&impugBean.getFechaDeses()==null){
					listaFinal.add(actaBean);
					agnadido = true;
				}
			
		}
		else if("2".equals(impugBean.getOrderby())){
			preavisoBean = new W83bPreavisosBean();//NOPMD
			preavisoBean.setNumPreaviso_completo(impugBean.getNumActa());
			preavisoBean.setAnyoPreaviso(impugBean.getAgnoActa());
			preavisoBean.setCodTerritorio(impugBean.getTerritorio());
			preavisoBean.setNumImpug(impugBean.getNumImpugnacion());
			preavisoBean.setFecha_entrada(impugBean.getFechaEntrada());
			preavisoBean.setObservaciones(impugBean.getObservaciones());
			preavisoBean.getCentroTrabajo().setCodCentroTrabajo(impugBean.getCodcentro());
			preavisoBean.setRazonSocialPreaviso(impugBean.getRazonSocial());
			preavisoBean.setDomicilioPreaviso(impugBean.getDomicilio());
			preavisoBean.setAgnoImpug(impugBean.getAgnoImpugnacion());
			preavisoBean.setFechaImpug(impugBean.getFechaImpugnacion());
			preavisoBean.setIdioma(param.getIdioma());
		
		}
		if(!agnadido){
			if(impugBean.getResultadoLaudo()!=null){
				if((W83bClsConstantes.UNO+"").equals(impugBean.getResultadoLaudo())){
					if(actaBean!=null&&StringUtils.isEmpty(actaBean.getFechaBaja())){
						listaFinal.add(actaBean);
						agnadido = true;
					}
					if(preavisoBean!=null){
						listaFinal.add(preavisoBean);
						agnadido = true;
					}
				}
			}else{
				if(actaBean!=null&&StringUtils.isEmpty(actaBean.getFechaBaja())){
					listaFinal.add(actaBean);
					agnadido = true;
				}
				if(preavisoBean!=null){
					listaFinal.add(preavisoBean);
					agnadido = true;
				}
			}
		}
	}
	return listaFinal;	
}

public List buscarPendientesImpugnaciones(W83bListImpugnacionesBean param)
		throws Exception {
	List listaActas = W83bFactoriaDAO.getListadosDAO().buscarPendientesImpugnaciones(param);
	List listaFinal = new ArrayList();
	
	Iterator ite=listaActas.iterator();
	
	while (ite.hasNext()){
		W83bListImpugnacionesBean impugBean = (W83bListImpugnacionesBean) ite.next();
		
		String existe = impugBean.getResultadoLaudo();
		if(StringUtils.isEmpty(impugBean.getFechaDeses())&&existe==null){
			//si tiene fecha de desestimiento, busco la impugnacin en los laudos

				listaFinal.add(impugBean);

		}
		
	}
	
	
	return listaFinal;
}

public List buscarResueltasImpugnaciones(W83bListImpugnacionesBean param)
		throws Exception {
	List listaActas = W83bFactoriaDAO.getListadosDAO().buscarResueltasImpugnaciones(param);
	List listaFinal = new ArrayList();
	
	Iterator ite=listaActas.iterator();
	
	while (ite.hasNext()){
		W83bListImpugnacionesBean impugBean = (W83bListImpugnacionesBean) ite.next();
		String descprovincia=W83bFactoriaDAO.getListadosDAO().obtenerdescprovincia(impugBean);
		impugBean.setDescTerritorio(descprovincia);
		
		if(StringUtils.isEmpty(impugBean.getFechaDeses())){
			//si no tiene fecha de desestimiento miro si tiene laudo
			if(StringUtils.isNotEmpty(impugBean.getNumLaudo())&&StringUtils.isNotEmpty(impugBean.getAgnoLaudo())){
				//si tiene laudo, me interesa
					listaFinal.add(impugBean);
			}
		}else{
			//si tiene fecha de desestimiento me interesa
			listaFinal.add(impugBean);
		}
		
	}
	
	
	return listaFinal;
}

public String actFechaRegResolDen(List param) throws Exception{
	
	String num=(String)W83bFactoriaDAO.getListadosDAO().actFechaRegResolDen(param);
		
	return num;	
}
public List buscarRelacionBajas(W83bListadosBean param) throws Exception {
	List listaRelacionBajas = W83bFactoriaDAO.getListadosDAO().buscarRelacionBajas(param);
	
	return listaRelacionBajas;	
}
public List buscarDelegadosActas(W83bListadosBean param) throws Exception {
	List listaDelegadosActas = W83bFactoriaDAO.getListadosDAO().buscarDelegadosActas(param);
	
	List listaDelegadosFinal = new ArrayList();
	HashMap tablaActas=new HashMap();
	
	for(int j=0;j<listaDelegadosActas.size();j++){
		W83bListadosBean current = (W83bListadosBean)listaDelegadosActas.get(j);
		String clave =current.getTerritorio()+"/"+current.getAnyoActa()+"/"+current.getActa();
		W83bListadosBean anterior = (W83bListadosBean) tablaActas.get(clave);
		if(anterior==null){
			tablaActas.put(clave, current);
			W83bListaDelegadosBean del = new W83bListaDelegadosBean();//NOPMD
			del.setNombre(current.getNombre());
			del.setApellido1(current.getApellido1());
			del.setApellido2(current.getApellido2());
			del.setSexo(current.getSexo());
			del.setCodColegio(current.getCodColegio());
			del.setColegio(current.getColegio());
			del.setCodSindicato(current.getCodSindicato());
			del.setSindicato(current.getSindicato());
			del.setSiglas(current.getSiglas());
			del.setFechaBaja(current.getFechaBaja());
			del.setMotivoBaja(current.getMotivoBaja());
			del.setDni(current.getDni());
			del.setDniSustituto(current.getDniSustituto());
			HashMap delegados = new HashMap();//NOPMD
			delegados.put(del.getDni(), del);
			current.setDelegados(delegados);
			listaDelegadosFinal.add(current);
		}else{
			int h=0;
			boolean encontrado = false;
			while(h<listaDelegadosFinal.size()&&!encontrado){
				W83bListadosBean guardadosAntes = (W83bListadosBean) listaDelegadosFinal.get(h);
				String claveAntigua =guardadosAntes.getTerritorio()+"/"+guardadosAntes.getAnyoActa()+"/"+guardadosAntes.getActa();
				if(claveAntigua.equalsIgnoreCase(clave)){
					HashMap delegadosAnteriores = guardadosAntes.getDelegados();
					W83bListaDelegadosBean del = new W83bListaDelegadosBean();//NOPMD
					del.setNombre(current.getNombre());
					del.setApellido1(current.getApellido1());
					del.setApellido2(current.getApellido2());
					del.setSexo(current.getSexo());
					del.setCodColegio(current.getCodColegio());
					del.setColegio(current.getColegio());
					del.setCodSindicato(current.getCodSindicato());
					del.setSindicato(current.getSindicato());
					del.setSiglas(current.getSiglas());
					del.setFechaBaja(current.getFechaBaja());
					del.setMotivoBaja(current.getMotivoBaja());
					del.setDni(current.getDni());
					del.setDniSustituto(current.getDniSustituto());
					delegadosAnteriores.put(del.getDni(), del);
					guardadosAntes.setDelegados(delegadosAnteriores);
					encontrado=true;
				}
				h++;
			}
		}
		
	}
	
	return listaDelegadosFinal;
}

public List buscarDelegadosIncompletos(W83bListadosBean param) throws Exception {
	//1 CONSULTA
	List listaDelegadosActas = W83bFactoriaDAO.getListadosDAO().buscarDelegadosIncompletos(param);
	W83bClsTrazas.trazaDebug(null, "listaDelegadosActas::: " +listaDelegadosActas.size() );
	/*List listaResultados=new ArrayList();
	HashMap delegadosEsrutinio=new HashMap();
	HashMap delegadosDelegado=new HashMap();
	//metemos los datos en un hashmap
	String nacta="";
	W83bListadosBean datos=new W83bListadosBean();
	W83bListadosBean datosViejo=new W83bListadosBean();
	datosViejo.setMaximoDelegados("0");
	W83bActasBean acta=new W83bActasBean();
	W83bListaDelegadosBean listadelegados=new W83bListaDelegadosBean();
	String delegados="";
	int delegadosTotal=0;
	int delegadosHombres=0;
	int delegadosMujeres=0;
	String[] del;
	String[] se;
	for(int i=0;i<listaDelegadosActas.size();i++){
		datos=(W83bListadosBean)listaDelegadosActas.get(i);
		
		if(i==0){
			datosViejo=datos;
			nacta=datos.getNumActa();
			delegados=datos.getDelegadosTotal();
			del=delegados.split("#");
			delegadosEsrutinio.put(del[0]+"#H#"+del[1], del[2]);
			delegadosEsrutinio.put(del[0]+"#M#"+del[1], del[3]);
			acta.setNumActa(datos.getActa());
			acta.setNumActaAno(datos.getAnyoActa());
			acta.setNumActaTerritorio(datos.getTerritorio());
			acta.setVersion(datos.getVer());
			acta.setIdioma(param.getIdioma());
			acta.setUsuarioBean(param.getUsuarioBean());
			delegadosTotal=Integer.parseInt(del[2])+Integer.parseInt(del[3]);
			delegadosHombres=Integer.parseInt(del[2]);
			delegadosMujeres=Integer.parseInt(del[3]);
			//2 CONSULTA
			List d=W83bFactoriaDAO.getListadosDAO().buscarDelegadosActa(acta);
			delegadosDelegado.clear();
			int valor=0;
			for(int p=0;p<d.size();p++){
				listadelegados=(W83bListaDelegadosBean)d.get(p);
				if(StringUtils.isEmpty(listadelegados.getFechaBaja())){
					valor=Integer.parseInt(listadelegados.getNumero());
					if(delegadosDelegado.containsKey(listadelegados.getCodColegio()+"#"+listadelegados.getSexo()+"#"+listadelegados.getCodSindicato())){
						valor=valor+Integer.parseInt((String)delegadosDelegado.get(listadelegados.getCodColegio()+"#"+listadelegados.getSexo()+"#"+listadelegados.getCodSindicato()));
					}
					delegadosDelegado.put(listadelegados.getCodColegio()+"#"+listadelegados.getSexo()+"#"+listadelegados.getCodSindicato(), String.valueOf(valor));
				}
			}
			
			
		}
		else if(!nacta.equals(datos.getNumActa())){
			delegadosEsrutinio.clear();
			delegados=datosViejo.getDelegadosTotal();
			del=delegados.split("#");
			delegadosEsrutinio.put(del[0]+"#H#"+del[1], del[2]);
			delegadosEsrutinio.put(del[0]+"#M#"+del[1], del[3]);
			//el viejo
			datosViejo.setDelegadosHombres(String.valueOf(delegadosHombres));
			datosViejo.setDelegadosMujeres(String.valueOf(delegadosMujeres));
			//miramos si son diferentes
			if(Integer.parseInt(datosViejo.getMaximoDelegados())!=delegadosTotal){
				datosViejo.setIncompleto(true);
			}
			delegadosTotal=0;
			if(delegadosEsrutinio!=null&&!delegadosEsrutinio.isEmpty()){
				Collection c=delegadosEsrutinio.keySet();//recorremos los delegados de escrutinios
				Iterator itr=c.iterator();
				while(itr.hasNext()){
					String clave=(String)itr.next();
					int valorEscr=Integer.parseInt((String)delegadosEsrutinio.get(clave));
					if(valorEscr!=0){
						if(delegadosDelegado.get(clave)!=null){
							int valorDel=Integer.parseInt((String)delegadosDelegado.get(clave));
							if(valorDel<valorEscr){//hay mas en escrutinio que en delegados
								//lo mostramos
								datosViejo.setIncompleto(true);
								se=clave.split("#");
								if(se[1].equals("H"))
									datosViejo.setDelegadosHombres(String.valueOf(valorDel));
								else
									datosViejo.setDelegadosMujeres(String.valueOf(valorDel));
							}
						}
						else{//==>no hay en delegado el de escrutinio
							datosViejo.setIncompleto(true);
							se=clave.split("#");
							if(se[1].equals("H"))
								datosViejo.setDelegadosHombres("0");
							else
								datosViejo.setDelegadosMujeres("0");
							//lo mostramos
						}
					}
				}
			}
			listaResultados.add(datosViejo);
			//el nuevo
			delegadosEsrutinio.clear();
			nacta=datos.getNumActa();
			acta.setNumActa(datos.getActa());
			acta.setNumActaAno(datos.getAnyoActa());
			acta.setNumActaTerritorio(datos.getTerritorio());
			acta.setVersion(datos.getVer());
			acta.setIdioma(param.getIdioma());
			acta.setUsuarioBean(param.getUsuarioBean());
			//3 CONSULTA
			List d=W83bFactoriaDAO.getActasDAO().buscarDelegadosActa(acta);
			delegadosDelegado.clear();
			int valor=0;
			for(int p=0;p<d.size();p++){
				listadelegados=(W83bListaDelegadosBean)d.get(p);
				if(StringUtils.isEmpty(listadelegados.getFechaBaja())){
					valor=Integer.parseInt(listadelegados.getNumero());
					if(delegadosDelegado.containsKey(listadelegados.getCodColegio()+"#"+listadelegados.getSexo()+"#"+listadelegados.getCodSindicato())){
						valor=valor+Integer.parseInt((String)delegadosDelegado.get(listadelegados.getCodColegio()+"#"+listadelegados.getSexo()+"#"+listadelegados.getCodSindicato()));
					}
					delegadosDelegado.put(listadelegados.getCodColegio()+"#"+listadelegados.getSexo()+"#"+listadelegados.getCodSindicato(), String.valueOf(valor));
				}
			}
			delegados=datos.getDelegadosTotal();
			del=delegados.split("#");
			delegadosEsrutinio.put(del[0]+"#H#"+del[1], del[2]);
			delegadosEsrutinio.put(del[0]+"#M#"+del[1], del[3]);
			delegadosTotal=Integer.parseInt(del[2])+Integer.parseInt(del[3]);
			delegadosHombres=Integer.parseInt(del[2]);
			delegadosMujeres=Integer.parseInt(del[3]);
			datosViejo=datos;
		}
		else if(nacta.equals(datos.getNumActa())){
			delegados=datos.getDelegadosTotal();
			del=delegados.split("#");
			delegadosEsrutinio.put(del[0]+"#H#"+del[1], del[2]);
			delegadosEsrutinio.put(del[0]+"#M#"+del[1], del[3]);
			delegadosTotal=delegadosTotal+Integer.parseInt(del[2])+Integer.parseInt(del[3]);
			delegadosHombres=delegadosHombres+Integer.parseInt(del[2]);
			delegadosMujeres=delegadosMujeres+Integer.parseInt(del[3]);
		}
		
	}//FIN FOR
	datosViejo.setDelegadosHombres(String.valueOf(delegadosHombres));
	datosViejo.setDelegadosMujeres(String.valueOf(delegadosMujeres));
	if(Integer.parseInt(datosViejo.getMaximoDelegados())!=delegadosTotal){
		datosViejo.setIncompleto(true);
	}
	if(delegadosEsrutinio!=null&&!delegadosEsrutinio.isEmpty()){
		Collection c=delegadosEsrutinio.keySet();//recorremos los delegados de escrutinios
		Iterator itr=c.iterator();
		while(itr.hasNext()){
			String clave=(String)itr.next();
			int valorEscr=Integer.parseInt((String)delegadosEsrutinio.get(clave));
			if(valorEscr!=0){
				if(delegadosDelegado.get(clave)!=null){
					int valorDel=Integer.parseInt((String)delegadosDelegado.get(clave));
					if(valorDel<valorEscr){//hay mas en escrutinio que en delegados
						//lo mostramos
						datosViejo.setIncompleto(true);
						se=clave.split("#");
						if(se[1].equals("H"))
							datosViejo.setDelegadosHombres(String.valueOf(valorDel));
						else
							datosViejo.setDelegadosMujeres(String.valueOf(valorDel));
					}
				}
				else{//==>no hay en delegado el de escrutinio
					datosViejo.setIncompleto(true);
					se=clave.split("#");
					if(se[1].equals("H"))
						datosViejo.setDelegadosHombres("0");
					else
						datosViejo.setDelegadosMujeres("0");
					//lo mostramos
				}
			}
			//puede
		}
	}
	listaResultados.add(datosViejo);
	*/
	
	return listaDelegadosActas;	
}

	public List buscarActasVivasCentrosTrabajoRepetidos(W83bListadosActasVivasCentroRepeBean param) throws Exception {
		return W83bFactoriaDAO.getListadosDAO().buscarActasVivasCentrosTrabajoRepetidos(param);
	}
	
	public String anularActaPorFechaEleccion(HashMap param) throws Exception {
		
		Iterator keys = param.keySet().iterator();
		
		while(keys.hasNext()){
			String key = (String)keys.next();
			
			List listaActasMismoDni = (ArrayList)param.get(key);
			W83bListadosActasVivasCentroRepeBean actaFinal = (W83bListadosActasVivasCentroRepeBean)listaActasMismoDni.get(listaActasMismoDni.size()-1);
			listaActasMismoDni.remove(listaActasMismoDni.size()-1);
			String fechaBaja = actaFinal.getFeleccion();
			for(int i=0,size=listaActasMismoDni.size();i<size;i++){
				W83bFactoriaDAO.getListadosDAO().anularActaPorFechaEleccion((W83bListadosActasVivasCentroRepeBean)listaActasMismoDni.get(i), fechaBaja);
			}
		}
		
		
		return "0";
	}
}